CARAVAN2_SPAWNCOUNT = 1
CARAVAN2_RESPAWNCOUNT = 11
CARAVAN2_NECESSARY_AMOUNT = 8

---------------------------------------------------------------
function CreateQuestCaravans2()

	-- next caravan		
	Caravan2JobId = StartSimpleJob("QuestCaravan2")

	Caravan2SpawnTime = 180
	Caravan2SpawnCount = 1
	
	leftpatrolSpawner.SpawnCounter = 120
	middlepatrolSpawner.SpawnCounter = 120
	rightpatrolSpawner.SpawnCounter = 120
	
	overalltributes = 105
	Caravan2Counter = 0
	paidResources = 0
	Caravan2SurvivedCounter = 0
	
	CreateTributeForMoreCaravan2()

	GUIQuestTools.StartQuestInformation("Caravan", "CM02_04_TradingCaravans/QI_caravan2", 1, 1)	

	UpdateCaravan2CountInQuestInformation()

end

function UpdateCaravan2CountInQuestInformation()
	GUIQuestTools.UpdateQuestInformationString(Caravan2SurvivedCounter .. "/" .. CARAVAN2_NECESSARY_AMOUNT)
end



function CreateTributeForMoreCaravan2()
	local _L = {}
		for i = 101,104,1 do
			_L["Job"..i] = {}
			_L["Job"..i].Tribute = i
			Logic.AddTribute(	GetHumanPlayer(), 
								_L["Job"..i].Tribute,
								0,
								0,
								"Übergibt Capulet die Rohstoffe, damit die nächste Karawane erweitert wird: 1000 Rohstoffe von allem", 
								ResourceType.Gold,
								1000,
								ResourceType.Clay,
								1000,
								ResourceType.Wood,
								1000,
								ResourceType.Stone,
								1000,
								ResourceType.Iron,
								1000,
								ResourceType.Sulfur,
								1000
								)
			_L["Job"..i].Callback 	= TributeKarawanPaid
		SetupTributePaid(_L["Job"..i])
	end
end

function createNextTributes2(_wanted)
	local _L = {}
		for i = (overalltributes+1),overalltributes+_wanted,1 do
			_L["Job"..i] = {}
			_L["Job"..i].Tribute = i
			Logic.AddTribute(	GetHumanPlayer(), 
								_L["Job"..i].Tribute,
								0,
								0,
								"Übergibt Capulet die Rohstoffe, damit die nächste Karawane erweitert wird: 1000 Rohstoffe von allen Rohstoffen.", 
								ResourceType.Gold,
								1000,
								ResourceType.Clay,
								1000,
								ResourceType.Wood,
								1000,
								ResourceType.Stone,
								1000,
								ResourceType.Iron,
								1000,
								ResourceType.Sulfur,
								1000
								)
			_L["Job"..i].Callback 	= TributeKarawanPaid
		SetupTributePaid(_L["Job"..i])
		end
	overalltributes = overalltributes + _wanted + 1
end



function QuestCaravan2()

	if IsBriefingActive() then
		return false
	end

	if Caravan2StartTime == nil then
		
		Caravan2StartTime = Caravan2SpawnTime
		Counter.SetLimit("QuestCaravan2",Caravan2StartTime)

		-- show time
		MapLocal_StartCountDown(Caravan2StartTime)
	
	end

	if Counter.Tick("QuestCaravan2") then

		MapLocal_StopCountDown()
		local spawncaravans = CARAVAN2_SPAWNCOUNT + paidResources
		
		if (spawncaravans + Caravan2SpawnCount) > CARAVAN2_RESPAWNCOUNT then
			spawncaravans = CARAVAN2_RESPAWNCOUNT - Caravan2SpawnCount
		end
		
		-- create caravan
		for i=1,spawncaravans do
			CreateEntity(7,Entities.PU_Travelling_Salesman,GetPosition("Caravan2SpawnPoint"..i),"Caravan_"..Caravan2SpawnCount.."_"..i)
		end
		
		local Quest 		= {}
		Quest.Unit 			= "Caravan_"..Caravan2SpawnCount.."_"
		
		Quest.Waypoint 	= {}
		
		for i=2,4 do
			Quest.Waypoint[i-1] = { Name = "Caravan_WP"..i, WaitTime = 40 }
		end
		
		Quest.Remove 		= true		
	
		Quest.Callback 			= QuestCaravan2Done
		Quest.ArrivedCallback 	= QuestCaravan2UpdateSurvivedCounter
	
		SetupCaravan(Quest)
	
		Caravan2SpawnCount = Caravan2SpawnCount + spawncaravans
		
		if Caravan2SpawnCount <= CARAVAN2_RESPAWNCOUNT+1 then
			
			if (Caravan2SpawnCount + paidResources) > CARAVAN2_RESPAWNCOUNT then
				paidResources = CARAVAN2_RESPAWNCOUNT -  Caravan2SpawnCount - 1
			end
			if (CARAVAN2_RESPAWNCOUNT - Caravan2SpawnCount) <= 4 then
				for i = 100, overalltributes,1 do
					Logic.RemoveTribute(1,i)
				end
				paidResources = (CARAVAN2_RESPAWNCOUNT - (Caravan2SpawnCount + 1))
			end
			
			createNextTributes2(paidResources)
			paidResources = 0
			Caravan2StartTime = nil
			Caravan2SpawnTime = 270
			
			Caravan2JobId = StartSimpleJob("QuestCaravan2")
			
		end	
		
		--StartCutscene
		StartCutscene(Cutscenes[THRESHOLDONECUTSCENE])
		return true	
		
	end
	
end

function QuestCaravan2UpdateSurvivedCounter(_Quest)
	if caravan2ended == true then
		return
	end

	Caravan2SurvivedCounter = Caravan2SurvivedCounter + 1

	UpdateCaravan2CountInQuestInformation()

end

function QuestCaravan2Done(_Quest)
	if caravan2ended == true then
		return
	end

	Caravan2Counter = Caravan2Counter + _Quest.ArrivedCount
	
	if Caravan2SurvivedCounter >= CARAVAN2_NECESSARY_AMOUNT then
	
		GUIQuestTools.DisableQuestInformation()
		
		for i =1, overalltributes,1 do
			Logic.RemoveTribute(1,i)
		end
	
		EndJob(Caravan2JobId)
		MapLocal_StopCountDown()
		
		caravan2ended = true

		end4thChapter()

	elseif Caravan2Counter == CARAVAN2_RESPAWNCOUNT then

		Defeat()

	end
		
end
